const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_masterLOD', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Stage: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    PrdType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ReportType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BFGCode: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NA"
    },
    MPN_Code: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    LHSContainerNo: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    RHSContainerNo: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    NoOfStations: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    ProductName: {
      type: DataTypes.STRING(250),
      allowNull: true
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NA"
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NA"
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleType: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    Nom: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    NMT: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    StdLimit1: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    StdLimit2: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    Tol1NegActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol1PosActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2NegActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2PosActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol1Neg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol1Pos: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol2Neg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol2Pos: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    GraphOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    MinValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Remark: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StartDate: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    EndDate: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    FinalMinDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    FinalMaxDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    FinalAvgDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    BatchCompleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    StdTime: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    InstrumentID: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    MPN_Code: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CubicName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LotNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NA"
    },
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_masterLOD',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_batc__647BBB29F0E41DB8",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
